
#%%
# le début de ce programme est le même que celui script précédent 


import numpy as np
import matplotlib.pyplot as plt

t=8*np.arange(11)
Xmes=np.array([-0.2,2.9,5.4,6.4,5,1.2,-3.4,-6.4,-6.9,-5.7,-3.3])
Ymes=np.array([-8.2,-7.3,-4.9,-1.2,2.9,5.3,4.7,1.5,-2.3,-5.5,-7.5])
x=Xmes*0.46/8.2
y=Ymes*0.46/8.2

vxl=[]
m=np.arange(len(t)-2)
for i in m :
    vx=(x[i+2]-x[i])/(t[i+2]-t[i])
    vxl.append(vx)

vyl=[]
m=np.arange(len(t)-2)
for i in m :
    vy=(y[i+2]-y[i])/(t[i+2]-t[i])
    vyl.append(vy)

axl=[]
m=np.arange(len(t)-4)
for i in m :
    ax=(vxl[i+2]-vxl[i])/(t[i+2]-t[i])
    axl.append(ax)
ayl=[]
m=np.arange(len(t)-4)
for i in m :
    ay=(vyl[i+2]-vyl[i])/(t[i+2]-t[i])
    ayl.append(ay)
#%%
# Courbe
plt.figure() # on fait tracer les vecteurs accélérations avec la constructions classiques
for i in m :
    plt.arrow(x[i+2],y[i+2],200*axl[i],200*ayl[i],head_width=0.02) # le facteur 200 est là pour la visibilité. 
plt.xlim(-15,15)
plt.ylim(-15,15)
plt.axis('equal')
plt.grid()
plt.plot(x,y,'bo')
plt.show()

#%%

ayln=1.5*10**11*np.array(ayl)/(24*3600)**2 # On convertit en unités SI les distances et le temps
axln=1.5*10**11*np.array(axl)/(24*3600)**2 #idem
norma=(ayln**2+axln**2)**(1/2)
dx=x[:-2]*1.5*10**11 # on supprime les deux dernières valeurs de la liste et on convertit
dy=y[:-2]*1.5*10**11 #la distance en SI
d=(dx**2+dy**2)**(1/2) #on calcule la norme de la distance

dr=d[2:] #on supprime les deux premières valeurs. 
GM=dr**2*norma # on calcule le produit GM en supposant la loi de la gravitation universelle
GMth=6.67*10**(-11)*2*10**30 # on calcule la valeur numérique à partir des grandeurs tabulées
n=np.arange(len(t)-4) #on change la longueur de la liste du temps, pour avoir le même
# nombre de points que dans la liste de l'accélération. 

#%%
# Courbe
plt.figure()
plt.plot(n,GM*10**(-20),'bo',label="points expérimentaux") # le facteur 10^-20 sert à la visibilté
plt.legend()
plt.grid()



mod=np.polyfit(n,GM,0) #on modélise GM par une constante
M=float(mod[0]/(6.67*10**(-11))) # on calcule la valeur de la masse du soleil
print('la masse du soleil est de l ordre de',"%.1e"%M,'kg') #on l'affiche
GMmod=0*n+mod[0] # on engendre une liste de cette valeur pour pouvoir tracer cette constante sur un graphe


plt.plot(n,(GMmod)*10**(-20),'r-',label="modèle") #graphe avec options classiques
plt.legend()
plt.ylim(0,5)
plt.xlabel("point de mesure")
plt.ylabel("valeur du produit GMs x10^20")
plt.show()

#%%
plt.figure()
drci=1/(dr)**2 #on calcule l'inverse du carré de la distance au soleil
plt.plot(drci,norma,'bo',label="points expérimentaux") # on trace la norme de l'accélération en fonction de l'inverse 
#du carré de la distance ; théoriquement, on doit obtenir une fonction linéaire. 
plt.legend()
plt.grid()
model=6.67*10**(-11)*1.7*10**30*drci # fonction théorique, pour comparaison. 
plt.plot(drci,model,'r-',label="modèle") #graphe classique, avec options classiques. 
plt.legend()
plt.xlabel("1/d^2")
plt.ylabel("accélération")
plt.show()
